/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.validation.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.vtst.eclipse.easyxtext.State;
import net.vtst.eclipse.easyxtext.validation.config.AdditionalBooleanOption;
import net.vtst.eclipse.easyxtext.validation.config.ConfigurableCheck;
import net.vtst.eclipse.easyxtext.validation.config.ConfigurableValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;

public class DeclarativeValidatorInspector {
    private String propertyNameQualifier;
    private boolean enabledByDefault = true;
    private Map<String, Group> groupByName = new HashMap<String, Group>();
    private ArrayList<Group> groupList = new ArrayList();
    private Collection<Field> additionalOptionFields;
    private IPreferenceStore preferenceStore;
    private static String CUSTOMIZED = "#customized";

    public DeclarativeValidatorInspector(AbstractDeclarativeValidator validator) {
        this.inspectTypeAnnotation(validator);
        for (Method method : this.getCheckMethods(validator)) {
            this.inspectMethod(method);
        }
        this.additionalOptionFields = this.getAdditionalOptionFields(validator);
        for (Field field : this.additionalOptionFields) {
            this.inspectField(field);
        }
        this.propertyNameQualifier = validator.getClass().getName();
        this.preferenceStore = PlatformUI.getWorkbench().getPreferenceStore();
    }

    public ArrayList<Group> getGroups() {
        return this.groupList;
    }

    private boolean stateToBoolean(State state) {
        switch (state) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        return this.enabledByDefault;
    }

    private void inspectTypeAnnotation(AbstractDeclarativeValidator validator) {
        ConfigurableValidator annotation = validator.getClass().getAnnotation(ConfigurableValidator.class);
        if (annotation == null) {
            return;
        }
        this.enabledByDefault = this.stateToBoolean(annotation.defaultState());
    }

    private void inspectMethod(Method method) {
        ConfigurableCheck annotation = method.getAnnotation(ConfigurableCheck.class);
        Group group = this.inspectAnnotation(annotation, method.getName());
        if (group != null) {
            group.methods.add(method);
        }
    }

    private void inspectField(Field field) {
        ConfigurableCheck annotation = field.getAnnotation(ConfigurableCheck.class);
        Group group = this.inspectAnnotation(annotation, field.getName());
        if (group != null) {
            group.fields.add(field);
        }
    }

    private Group inspectAnnotation(ConfigurableCheck annotation, String name) {
        Group group;
        String groupName = name;
        if (annotation != null && !annotation.configurable()) {
            return null;
        }
        if (annotation != null && !annotation.group().isEmpty()) {
            groupName = annotation.group();
        }
        if ((group = this.groupByName.get(groupName)) == null) {
            group = new Group();
            group.name = groupName;
            group.enabledByDefault = this.enabledByDefault;
            this.groupByName.put(groupName, group);
            this.groupList.add(group);
        }
        if (annotation != null) {
            if (annotation.defaultState() != State.DEFAULT) {
                group.enabledByDefault = this.stateToBoolean(annotation.defaultState());
            }
            if (!annotation.group().isEmpty()) {
                group.name = annotation.group();
            }
            if (!annotation.label().isEmpty()) {
                group.label = annotation.label();
            }
        }
        return group;
    }

    private Collection<Method> getCheckMethods(AbstractDeclarativeValidator validator) {
        try {
            Method collectMethodsMethod = AbstractDeclarativeValidator.class.getDeclaredMethod("collectMethods", Class.class);
            collectMethodsMethod.setAccessible(true);
            List methodWrappers = (List)collectMethodsMethod.invoke((Object)validator, validator.getClass());
            ArrayList<Method> result = new ArrayList<Method>(methodWrappers.size());
            Field methodField = null;
            for (Object methodWrapper : methodWrappers) {
                if (methodField == null) {
                    methodField = methodWrapper.getClass().getDeclaredField("method");
                    methodField.setAccessible(true);
                }
                Method method = (Method)methodField.get(methodWrapper);
                result.add(method);
            }
            return result;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private Collection<Field> getAdditionalOptionFields(AbstractDeclarativeValidator validator) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fieldArray = validator.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().equals(AdditionalBooleanOption.class)) {
                field.setAccessible(true);
                result.add(field);
            }
            ++n2;
        }
        return result;
    }

    public Collection<Field> getAdditionalOptionFields() {
        return this.additionalOptionFields;
    }

    private String getPropertyName(String name) {
        return String.valueOf(this.propertyNameQualifier) + ":" + name;
    }

    private String getPropertyName(Group group) {
        return this.getPropertyName(group.name);
    }

    public boolean getEnabled(Group group) {
        if (this.getCustomized()) {
            return this.preferenceStore.getBoolean(this.getPropertyName(group));
        }
        return group.enabledByDefault;
    }

    public void setEnabled(Group group, boolean enabled) {
        this.preferenceStore.setValue(this.getPropertyName(group), enabled);
    }

    public boolean getCustomized() {
        return this.preferenceStore.getBoolean(this.getPropertyName(CUSTOMIZED));
    }

    public void setCustomized(boolean customized) {
        this.preferenceStore.setValue(this.getPropertyName(CUSTOMIZED), customized);
    }

    private QualifiedName getQualifiedName(Group group) {
        return new QualifiedName(this.propertyNameQualifier, group.name);
    }

    public boolean getEnabled(IResource resource, Group group) throws CoreException {
        if (this.getCustomized(resource)) {
            String value = resource.getPersistentProperty(this.getQualifiedName(group));
            if (value == null) {
                return group.enabledByDefault;
            }
            return Boolean.parseBoolean(value);
        }
        return this.getEnabled(group);
    }

    public void setEnabled(IResource resource, Group group, boolean enabled) throws CoreException {
        resource.setPersistentProperty(this.getQualifiedName(group), Boolean.toString(enabled));
    }

    public boolean getCustomized(IResource resource) throws CoreException {
        String value = resource.getPersistentProperty(new QualifiedName(this.propertyNameQualifier, CUSTOMIZED));
        return value != null;
    }

    public void setCustomized(IResource resource, boolean customized) throws CoreException {
        resource.setPersistentProperty(new QualifiedName(this.propertyNameQualifier, CUSTOMIZED), customized ? "true" : null);
        if (!customized) {
            this.clearAllProperties(resource);
        }
    }

    private void clearAllProperties(IResource resource) throws CoreException {
        for (QualifiedName name : resource.getPersistentProperties().keySet()) {
            if (!name.getQualifier().equals(this.propertyNameQualifier) || name.getLocalName().startsWith("#")) continue;
            resource.setPersistentProperty(name, null);
        }
    }

    public static class Group {
        public String name;
        public String label = null;
        public boolean enabledByDefault;
        public List<Method> methods = new ArrayList<Method>(1);
        public List<Field> fields = new ArrayList<Field>(1);
    }
}

