/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.validation.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import net.vtst.eclipse.easyxtext.validation.config.DeclarativeValidatorInspector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class ConfigurableValidationMessageAcceptor
implements ValidationMessageAcceptor {
    private DeclarativeValidatorInspector inspector;
    private ValidationMessageAcceptor delegate;
    AbstractDeclarativeValidator.StateAccess stateAccess;
    private Cache cache = new Cache();

    public ConfigurableValidationMessageAcceptor(DeclarativeValidatorInspector inspector, ValidationMessageAcceptor delegate) {
        this.inspector = inspector;
        this.delegate = delegate;
    }

    public void resetCache(IProject project) {
        this.cache.reset(project);
    }

    public boolean getFieldValue(Resource resource, Field field) {
        ProjectConfiguration configuration = this.cache.get(resource);
        if (configuration == null) {
            return false;
        }
        return configuration.getFieldValue(field);
    }

    private boolean isDisabled() {
        AbstractDeclarativeValidator.State state = this.stateAccess.getState();
        if (state.currentObject == null) {
            return false;
        }
        ProjectConfiguration configuration = this.cache.get(state.currentObject.eResource());
        if (configuration == null) {
            return false;
        }
        return configuration.isDisabled(state.currentMethod);
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptError(message, object, feature, index, code, issueData);
    }

    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptError(message, object, offset, length, code, issueData);
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptWarning(message, object, feature, index, code, issueData);
    }

    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptWarning(message, object, offset, length, code, issueData);
    }

    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptInfo(message, object, feature, index, code, issueData);
    }

    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.isDisabled()) {
            return;
        }
        this.delegate.acceptInfo(message, object, offset, length, code, issueData);
    }

    public class Cache {
        private WeakHashMap<IProject, ProjectConfiguration> configurations = new WeakHashMap();
        private Resource lastResource;
        private ProjectConfiguration lastConfiguration;

        private IProject getProject(Resource resource) {
            URI uri = resource.getURI();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            if (file == null) {
                return null;
            }
            return file.getProject();
        }

        private ProjectConfiguration get(IProject project) {
            if (project == null) {
                return null;
            }
            ProjectConfiguration configuration = this.configurations.get(project);
            if (configuration == null) {
                configuration = new ProjectConfiguration(project);
                this.configurations.put(project, configuration);
            }
            return configuration;
        }

        public ProjectConfiguration get(Resource resource) {
            if (!resource.equals(this.lastResource)) {
                this.lastResource = resource;
                this.lastConfiguration = this.get(this.getProject(resource));
            }
            return this.lastConfiguration;
        }

        public void reset(IProject project) {
            if (project == null) {
                this.configurations.clear();
            } else {
                this.configurations.remove(project);
            }
        }
    }

    public class ProjectConfiguration {
        private Set<Method> disabledCheckMethods = new HashSet<Method>();
        private Set<Field> setFields = new HashSet<Field>();

        public ProjectConfiguration(IProject project) {
            try {
                for (DeclarativeValidatorInspector.Group group : ConfigurableValidationMessageAcceptor.this.inspector.getGroups()) {
                    if (ConfigurableValidationMessageAcceptor.this.inspector.getEnabled((IResource)project, group)) {
                        this.setFields.addAll(group.fields);
                        continue;
                    }
                    this.disabledCheckMethods.addAll(group.methods);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public boolean isDisabled(Method method) {
            return this.disabledCheckMethods.contains(method);
        }

        public boolean getFieldValue(Field field) {
            return this.setFields.contains(field);
        }
    }
}

