/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class GlobalScopeWithBuiltins
implements IScope {
    private LinkedHashMap<QualifiedName, IEObjectDescription> builtins = new LinkedHashMap(4);
    private IScope globalScope;

    public GlobalScopeWithBuiltins(IScope globalScope, Iterable<IEObjectDescription> builtins) {
        this.globalScope = globalScope;
        boolean ignoreCase = this.isIgnoreCase();
        Iterator<IEObjectDescription> iterator = builtins.iterator();
        while (iterator.hasNext()) {
            IEObjectDescription description;
            QualifiedName name = ignoreCase ? description.getName().toLowerCase() : description.getName();
            IEObjectDescription previous = this.builtins.put(name, description = iterator.next());
            if (previous == null) continue;
            this.builtins.put(name, previous);
        }
    }

    protected boolean isIgnoreCase() {
        return false;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription objectDescription = this.globalScope.getSingleElement(name);
        if (objectDescription != null) {
            return objectDescription;
        }
        return this.getBuiltinElementByName(name);
    }

    protected IEObjectDescription getBuiltinElementByName(QualifiedName name) {
        if (this.isIgnoreCase()) {
            return this.builtins.get(name.toLowerCase());
        }
        return this.builtins.get(name);
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        Iterable globalElements = this.globalScope.getElements(name);
        if (!Iterables.isEmpty((Iterable)globalElements)) {
            return globalElements;
        }
        IEObjectDescription objectDescription = this.getBuiltinElementByName(name);
        if (objectDescription == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(objectDescription);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        Iterable<IEObjectDescription> elements = this.getElements(object);
        Iterator<IEObjectDescription> iterator = elements.iterator();
        if (iterator.hasNext()) {
            IEObjectDescription result = iterator.next();
            return result;
        }
        return null;
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        URI uri = EcoreUtil2.getNormalizedURI((EObject)object);
        Iterable globalElements = this.globalScope.getElements(object);
        Iterable<IEObjectDescription> builtinElements = this.getBuiltinElementsByEObject(object, uri);
        return Iterables.concat((Iterable)globalElements, builtinElements);
    }

    private Iterable<IEObjectDescription> getBuiltinElementsByEObject(final EObject object, final URI uri) {
        Collection<IEObjectDescription> builtinElements = this.builtins.values();
        Iterable result = Iterables.filter(builtinElements, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return this.canBeFoundByName(input);
                }
                if (uri.equals(input.getEObjectURI())) {
                    return this.canBeFoundByName(input);
                }
                return false;
            }

            public boolean canBeFoundByName(IEObjectDescription input) {
                IEObjectDescription lookUp = GlobalScopeWithBuiltins.this.getBuiltinElementByName(input.getName());
                if (lookUp != null) {
                    if (lookUp == input) {
                        return true;
                    }
                    if (lookUp.getEObjectOrProxy() == object) {
                        return true;
                    }
                    if (uri.equals(lookUp.getEObjectURI())) {
                        return true;
                    }
                }
                return false;
            }
        });
        return result;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        Iterable globalElements = this.globalScope.getAllElements();
        Collection<IEObjectDescription> builtinElements = this.builtins.values();
        return Iterables.concat((Iterable)globalElements, builtinElements);
    }
}

