/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.scoping;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IResourceScopeCache;

public abstract class EasyUriGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    @Inject
    private IResourceScopeCache cache;

    protected abstract boolean getImportedUris(EObject var1, IAcceptor<String> var2);

    protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
        return (LinkedHashSet)this.cache.get(EasyUriGlobalScopeProvider.class, resource, (Provider)new Provider<LinkedHashSet<URI>>(){

            public LinkedHashSet<URI> get() {
                UriStringAcceptor uris = new UriStringAcceptor(resource);
                TreeIterator it = resource.getAllContents();
                while (it.hasNext()) {
                    if (EasyUriGlobalScopeProvider.this.getImportedUris((EObject)it.next(), uris)) continue;
                    it.prune();
                }
                return uris.get();
            }
        });
    }

    private static class UriStringAcceptor
    implements IAcceptor<String> {
        private Resource resource;
        private LinkedHashSet<URI> uris = new LinkedHashSet(10);

        public UriStringAcceptor(Resource resource) {
            this.resource = resource;
        }

        public void accept(String uriString) {
            URI uri;
            if (uriString != null && EcoreUtil2.isValidUri((Resource)this.resource, (URI)(uri = URI.createURI((String)uriString)))) {
                this.uris.add(uri);
            }
        }

        public LinkedHashSet<URI> get() {
            return this.uris;
        }
    }
}

