/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.util.Tuples;
import org.osgi.framework.Bundle;

@Singleton
public class EasyBuiltinResourceDescriptionProvider {
    @Inject
    private IResourceDescription.Manager descriptionManager;
    @Inject
    private IResourceFactory resourceFactory;
    private final SimpleCache<Pair<String, String>, Resource> resourceCache = new SimpleCache((Function)new Function<Pair<String, String>, Resource>(){

        public Resource apply(Pair<String, String> key) {
            Bundle bundle = Platform.getBundle((String)((String)key.getFirst()));
            try {
                Path path = new Path((String)key.getSecond());
                Resource resource = EasyBuiltinResourceDescriptionProvider.this.resourceFactory.createResource(URI.createURI((String)("platform:/resource/" + (String)key.getFirst() + "/" + path.toString())));
                InputStream inputStream = FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)false);
                resource.load(inputStream, new HashMap());
                return resource;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    });
    private final SimpleCache<Pair<String, String>, IResourceDescription> resourceDescriptionCache = new SimpleCache((Function)new Function<Pair<String, String>, IResourceDescription>(){

        public IResourceDescription apply(Pair<String, String> key) {
            Resource resource = (Resource)EasyBuiltinResourceDescriptionProvider.this.resourceCache.get(key);
            if (resource == null) {
                return null;
            }
            return EasyBuiltinResourceDescriptionProvider.this.descriptionManager.getResourceDescription(resource);
        }
    });
    private final SimpleCache<Pair<String, Iterable<String>>, Iterable<IEObjectDescription>> objectDescriptionsCache = new SimpleCache((Function)new Function<Pair<String, Iterable<String>>, Iterable<IEObjectDescription>>(){

        public Iterable<IEObjectDescription> apply(Pair<String, Iterable<String>> key) {
            ArrayList<IEObjectDescription> objectDescriptions = new ArrayList<IEObjectDescription>();
            String bundleName = (String)key.getFirst();
            for (String filename : (Iterable)key.getSecond()) {
                IResourceDescription resourceDescription = (IResourceDescription)EasyBuiltinResourceDescriptionProvider.this.resourceDescriptionCache.get((Object)Tuples.pair((Object)bundleName, (Object)filename));
                if (resourceDescription == null) continue;
                Iterables.addAll(objectDescriptions, (Iterable)resourceDescription.getExportedObjects());
            }
            return objectDescriptions;
        }
    });

    public final Resource getResource(String bundleName, String filename) {
        return (Resource)this.resourceCache.get((Object)Tuples.pair((Object)bundleName, (Object)filename));
    }

    public final IResourceDescription getResourceDescription(String bundleName, String filename) {
        return (IResourceDescription)this.resourceDescriptionCache.get((Object)Tuples.pair((Object)bundleName, (Object)filename));
    }

    public final Iterable<IEObjectDescription> getObjectDescriptions(String bundleName, Iterable<String> filenames) {
        return (Iterable)this.objectDescriptionsCache.get((Object)Tuples.pair((Object)bundleName, filenames));
    }
}

