/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.parser;

import java.nio.CharBuffer;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public class EasyScanner {
    private Scanner scanner;
    private CharStream input;
    private ReadableCharStream readableInput;

    public EasyScanner(CharStream input) {
        this.setInputCharStream(input);
    }

    private void prepareToScan() {
        this.readableInput.reset();
        this.scanner = new Scanner(this.readableInput);
    }

    public void setInputCharStream(CharStream input) {
        this.input = input;
        this.readableInput = new ReadableCharStream(input);
    }

    private void seekInput(MatchResult matchResult) {
        if (matchResult == null) {
            return;
        }
        this.input.seek(this.input.index() + matchResult.end() - matchResult.start());
    }

    private void seekInput(int offset) {
        this.input.seek(this.input.index() + offset);
    }

    public EasyScanResult scan(Pattern pattern) {
        this.prepareToScan();
        MatchResult m = null;
        if (this.scanner.findWithinHorizon(pattern, 0) != null) {
            m = this.scanner.match();
        }
        EasyScanResult r = new EasyScanResult(this.input, m);
        if (m != null) {
            this.seekInput(m.start());
        }
        return r;
    }

    public EasyMatchResult match(Pattern pattern) {
        this.prepareToScan();
        MatchResult m = null;
        if (this.scanner.findWithinHorizon(pattern, 0) != null) {
            m = this.scanner.match();
        }
        EasyMatchResult r = new EasyMatchResult(this.input, m);
        this.seekInput(m);
        return r;
    }

    public static String getErrorMessage(Token token, String defaultErrorMessage) {
        if (!(token instanceof EasyToken)) {
            return null;
        }
        String message = ((EasyToken)token).getErrorMessage();
        if (message == null) {
            return defaultErrorMessage;
        }
        return message;
    }

    public static class EasyMatchResult
    extends EasyResult {
        protected MatchResult matchResult;

        public EasyMatchResult(CharStream input, MatchResult matchResult) {
            super(input);
            this.matchResult = matchResult;
        }

        public boolean matched() {
            return this.matchResult != null;
        }

        public String matchGroup(int index) {
            if (this.matchResult == null) {
                return null;
            }
            return this.matchResult.group(index);
        }

        @Override
        public EasyToken getToken(int tokenType, int channel) {
            return this.getToken(tokenType, channel, 0);
        }

        public EasyToken getToken(int tokenType, int channel, int group) {
            if (this.matchResult == null || this.matchResult.group(group) == null) {
                return this.createEmptyErrorToken();
            }
            EasyToken token = new EasyToken(this.input, tokenType, channel, this.index + this.matchResult.start(group), this.index + this.matchResult.end(group) - 1);
            token.setLine(this.line);
            token.setCharPositionInLine(this.charPositionInLine);
            token.setText(this.matchResult.group(group));
            return token;
        }

        @Override
        public EasyToken addToToken(Token token) {
            return this.addToToken(token, 0);
        }

        private EasyToken addToToken(Token token, int group) {
            if (this.matchResult == null || this.matchResult.group(group) == null) {
                return EasyToken.castToError(token);
            }
            String matchedText = this.matchResult.group(group);
            EasyToken easyToken = EasyToken.cast(token);
            easyToken.setStartIndex(Math.min(easyToken.getStartIndex(), this.index + this.matchResult.start(group)));
            easyToken.setStopIndex(Math.max(easyToken.getStopIndex(), this.index + this.matchResult.end(group) - 1));
            easyToken.setText(String.valueOf(token.getText()) + matchedText);
            return easyToken;
        }

        public String toString() {
            if (this.matchResult == null) {
                return "null";
            }
            return this.matchResult.toString();
        }
    }

    public static abstract class EasyResult {
        protected CharStream input;
        protected int index;
        protected int line;
        protected int charPositionInLine;

        public EasyResult(CharStream input) {
            this.input = input;
            this.index = input.index();
            this.line = input.getLine();
            this.charPositionInLine = input.getCharPositionInLine();
        }

        public abstract EasyToken getToken(int var1, int var2);

        public abstract EasyToken addToToken(Token var1);

        protected EasyToken createEmptyErrorToken() {
            EasyToken token = new EasyToken(this.input, 0, 99, this.index, this.index);
            token.setLine(this.line);
            token.setCharPositionInLine(this.charPositionInLine);
            token.setText("");
            return token;
        }
    }

    public static class EasyScanResult
    extends EasyResult {
        protected int scanFoundIndex;

        public EasyScanResult(CharStream input, MatchResult matchResult) {
            super(input);
            this.scanFoundIndex = matchResult == null ? -1 : matchResult.start();
        }

        @Override
        public EasyToken getToken(int tokenType, int channel) {
            return this.getToken(tokenType, channel, 0);
        }

        public EasyToken getToken(int tokenType, int channel, int group) {
            if (this.scanFoundIndex < 0) {
                return this.createEmptyErrorToken();
            }
            EasyToken token = new EasyToken(this.input, tokenType, channel, this.index, this.index + this.scanFoundIndex - 1);
            token.setLine(this.line);
            token.setCharPositionInLine(this.charPositionInLine);
            token.setText(this.input.substring(this.index, this.index + this.scanFoundIndex - 1));
            return token;
        }

        @Override
        public EasyToken addToToken(Token token) {
            return this.addToToken(token, 0);
        }

        private EasyToken addToToken(Token token, int group) {
            if (this.scanFoundIndex < 0) {
                return EasyToken.castToError(token);
            }
            String matchedText = this.input.substring(this.index, this.index + this.scanFoundIndex - 1);
            EasyToken easyToken = EasyToken.cast(token);
            easyToken.setStartIndex(Math.min(easyToken.getStartIndex(), this.index));
            easyToken.setStopIndex(Math.max(easyToken.getStopIndex(), this.index + matchedText.length()));
            easyToken.setText(String.valueOf(token.getText()) + matchedText);
            return easyToken;
        }
    }

    public static class EasyToken
    extends CommonToken {
        private static final long serialVersionUID = 1L;
        private String errorMessage = null;

        private EasyToken(CharStream input, int type, int channel, int start, int stop) {
            super(input, type, channel, start, stop);
        }

        private EasyToken(Token token) {
            super(token);
        }

        public void setAsError(String errorMessage) {
            this.errorMessage = errorMessage;
            this.setType(0);
            this.setChannel(99);
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isError() {
            return this.errorMessage != null;
        }

        public static EasyToken cast(Token token) {
            if (token instanceof EasyToken) {
                return (EasyToken)token;
            }
            return new EasyToken(token);
        }

        public static EasyToken castToError(Token token) {
            EasyToken easyToken = EasyToken.cast(token);
            easyToken.setType(0);
            easyToken.setChannel(99);
            return easyToken;
        }
    }

    private static class ReadableCharStream
    implements Readable {
        private CharStream stream;
        private int look_ahead = 0;

        public ReadableCharStream(CharStream stream) {
            this.stream = stream;
        }

        public void reset() {
            this.look_ahead = 0;
        }

        @Override
        public int read(CharBuffer buffer) {
            ++this.look_ahead;
            if (this.stream.LA(this.look_ahead) == -1) {
                return -1;
            }
            buffer.append((char)this.stream.LA(this.look_ahead));
            return 1;
        }
    }
}

