/*
 * Decompiled with CFR 0.152.
 */
package net.vtst.eclipse.easyxtext.nature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class ProjectNatureUtil {
    private static String XTEXT_NATURE_ID = "org.eclipse.xtext.ui.shared.xtextNature";

    public static boolean hasNature(String natureId, IProject project) throws CoreException {
        String[] stringArray = project.getDescription().getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (natureId.equals(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addNatures(Collection<String> natureIds, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] currentNatureIds = description.getNatureIds();
        HashSet<String> newNatureIds = new HashSet<String>(natureIds.size() + currentNatureIds.length);
        String[] stringArray = currentNatureIds;
        int n = currentNatureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            newNatureIds.add(n3);
            ++n2;
        }
        newNatureIds.addAll(natureIds);
        description.setNatureIds(newNatureIds.toArray(new String[0]));
        project.setDescription(description, null);
    }

    public static void removeNatures(Collection<String> natureIds, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] currentNatureIds = description.getNatureIds();
        HashSet<String> newNatureIds = new HashSet<String>(currentNatureIds.length);
        String[] stringArray = currentNatureIds;
        int n = currentNatureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            newNatureIds.add(n3);
            ++n2;
        }
        newNatureIds.removeAll(natureIds);
        description.setNatureIds(newNatureIds.toArray(new String[0]));
        project.setDescription(description, null);
    }

    public static void addNatureRequiringXtext(String natureId, IProject project) throws CoreException {
        ArrayList<String> natureIds = new ArrayList<String>(2);
        natureIds.add(XTEXT_NATURE_ID);
        natureIds.add(natureId);
        ProjectNatureUtil.addNatures(natureIds, project);
    }

    public static void removeNatureRequiringXtext(String natureId, boolean alsoRemoveXtextNature, IProject project) throws CoreException {
        ArrayList<String> natureIds = new ArrayList<String>(2);
        if (alsoRemoveXtextNature) {
            natureIds.add(XTEXT_NATURE_ID);
        }
        natureIds.add(natureId);
        ProjectNatureUtil.removeNatures(natureIds, project);
    }
}

