(***********************************************************************)
(*                           ocamldsort                                *)
(*                                                                     *)
(*                 Copyright (C) 2002  Dimitri Ara                     *)
(*                                                                     *)
(* This program is free software; you can redistribute it and/or       *)
(* modify it under the terms of the GNU General Public License         *)
(* as published by the Free Software Foundation; either version 2      *)
(* of the License, or (at your option) any later version.              *)
(*                                                                     *)
(* This program is distributed in the hope that it will be useful,     *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of      *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *)
(* GNU General Public License for more details.                        *)
(*                                                                     *)
(* You should have received a copy of the GNU General Public License   *)
(* along with this program; if not, write to the Free Software         *)
(* Foundation, Inc.,                                                   *)
(* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           *)
(***********************************************************************)

type ocamldep =
    { path : string;
      load_path : string list;
      preprocessor : string option }

type input = Ocamldep of ocamldep | Input_file of string | Stdin

type t = 
    { input : input;
      files : string list;
      sort_mli : bool }

let to_sort_mli param =
  param.sort_mli

let to_change_extension param =
  if to_sort_mli param then
    Files.change_cmo_cmi_extension
  else
    Files.change_cmo_extension

let to_input_param param =
  param.input

let to_path input_param =
  input_param.path

let to_load_path input_param =
  String.concat " -I " input_param.load_path

let to_preprocesor input_param =
  match input_param.preprocessor with
    | Some p -> "-pp " ^ p
    | None -> ""

let to_files param =
  param.files

let to_concatened_files param =
  String.concat " " (to_files param)


let to_command_line param =
  match param.input with
    | Ocamldep input_param ->
	Printf.sprintf "%s %s %s %s"
	(to_path input_param)
	(to_load_path input_param)
	(to_preprocesor input_param)
	(to_concatened_files param)
    | _ -> failwith "to_command_line"

let to_stream param = 
  match (to_input_param param) with
    | Ocamldep _ ->
	let ic = Unix.open_process_in
		   (to_command_line param) in
	  at_exit (fun () -> close_in ic);
	  Stream.of_channel ic
    | Input_file file ->
	let ic = open_in file in
	  at_exit (fun () -> close_in ic);
	  Stream.of_channel ic
    | Stdin ->
	Stream.of_channel stdin

let new_file_input_param file =
  Input_file file
    
let new_ocamldep_input_param path load_path preprocessor =
  let ocamldep = { path = path;
		   load_path = load_path;
		   preprocessor = preprocessor } in
    Ocamldep ocamldep
  
let new_param input_param files sort_mli =
  { input = input_param;
    files = files;
    sort_mli = sort_mli }
