(***********************************************************************)
(*                           ocamldsort                                *)
(*                                                                     *)
(*                 Copyright (C) 2002  Dimitri Ara                     *)
(*                                                                     *)
(* This program is free software; you can redistribute it and/or       *)
(* modify it under the terms of the GNU General Public License         *)
(* as published by the Free Software Foundation; either version 2      *)
(* of the License, or (at your option) any later version.              *)
(*                                                                     *)
(* This program is distributed in the hope that it will be useful,     *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of      *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *)
(* GNU General Public License for more details.                        *)
(*                                                                     *)
(* You should have received a copy of the GNU General Public License   *)
(* along with this program; if not, write to the Free Software         *)
(* Foundation, Inc.,                                                   *)
(* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           *)
(***********************************************************************)

exception Unknown_extension of string

type sort_mli = Sort_ml | Sort_ml_mli

let is_cmo file =
  Filename.check_suffix file ".cmo"

let is_cmi file =
  Filename.check_suffix file ".cmi"

let is_ml file =
  Filename.check_suffix file ".ml"

let is_mli file =
  Filename.check_suffix file ".mli"

let suffix_list = 
  [".cmo"; ".cmi"; ".ml"; ".mli";
   ".mll"; ".mly" ]
    
let chop_suffix file =
  let rec chop_suffix_aux = function
    | hd :: tl ->
	if Filename.check_suffix file hd then
	  Filename.chop_suffix file hd
	else
	  chop_suffix_aux tl
    | [] -> raise (Unknown_extension file) in
  chop_suffix_aux suffix_list

let to_ml file = 
  file ^ ".ml"

let to_mli file =
  file ^ ".mli"

let to_cmo file = 
  file ^ ".cmo"

let to_cmi file =
  file ^ ".cmi"

let change_failed func file =
  failwith (func ^ " called with file " ^ file)

let change_cmo_extension file =
  let file_without_ext = Filename.chop_extension file in
    if is_cmo file then 
      to_ml file_without_ext
    else if is_cmi file then
      to_ml file_without_ext
    else 
      change_failed "change_cmo_extension" file
	
let change_cmo_cmi_extension file =		  
  let file_without_ext = Filename.chop_extension file in
    if is_cmo file then
      to_ml file_without_ext
    else if is_cmi file then
      to_mli file_without_ext
    else
      change_failed "change_cmo_cmi_extension" file
	
let change_ml_mli_extension file =
  let file_without_ext = Filename.chop_extension file in
    if is_ml file then
      to_cmo file_without_ext
    else if is_mli file then
      to_cmi file_without_ext
    else
      change_failed "change_ml_mli_extension" file
