(***********************************************************************)
(*                           ocamldsort                                *)
(*                                                                     *)
(*                 Copyright (C) 2002  Dimitri Ara                     *)
(*                                                                     *)
(* This program is free software; you can redistribute it and/or       *)
(* modify it under the terms of the GNU General Public License         *)
(* as published by the Free Software Foundation; either version 2      *)
(* of the License, or (at your option) any later version.              *)
(*                                                                     *)
(* This program is distributed in the hope that it will be useful,     *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of      *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *)
(* GNU General Public License for more details.                        *)
(*                                                                     *)
(* You should have received a copy of the GNU General Public License   *)
(* along with this program; if not, write to the Free Software         *)
(* Foundation, Inc.,                                                   *)
(* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           *)
(***********************************************************************)

let rec sources_filter param target = function
  | hd :: tl ->
      let file = Params.to_change_extension param hd in
	if file <> target && List.mem file (Params.to_files param) then 
	  file :: sources_filter param target tl
	else
	  sources_filter param target tl
  | [] -> []

let rec clean_dependencies param = function
  | (target, sources) :: tl ->
      if (Files.is_cmo target ||
	  (Files.is_cmi target && Params.to_sort_mli param)) && 
	List.mem (Params.to_change_extension param target)
	  (Params.to_files param)
      then
	let new_target = Params.to_change_extension param target in
          (new_target, sources_filter param new_target sources)
	  :: clean_dependencies param tl
      else
	clean_dependencies param tl
  | [] -> []

let rec add_independent_dependencies deps = function 
  | hd :: tl -> 
      if List.mem_assoc hd deps then
	add_independent_dependencies deps tl
      else
	add_independent_dependencies ((hd, []) :: deps) tl
  | [] -> deps

let get_dependencies param =
  let raw_deps = Dep_parse.parse_ocamldep (Params.to_stream param) in
(*   let _ = Dep_debug.print_deps raw_deps in *)
  let cleaned_deps = clean_dependencies param raw_deps in
(*   let _ = Dep_debug.print_deps cleaned_deps in *)
    add_independent_dependencies cleaned_deps (Params.to_files param)
