(***********************************************************************)
(*                           ocamldsort                                *)
(*                                                                     *)
(*                 Copyright (C) 2002  Dimitri Ara                     *)
(*                                                                     *)
(* This program is free software; you can redistribute it and/or       *)
(* modify it under the terms of the GNU General Public License         *)
(* as published by the Free Software Foundation; either version 2      *)
(* of the License, or (at your option) any later version.              *)
(*                                                                     *)
(* This program is distributed in the hope that it will be useful,     *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of      *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *)
(* GNU General Public License for more details.                        *)
(*                                                                     *)
(* You should have received a copy of the GNU General Public License   *)
(* along with this program; if not, write to the Free Software         *)
(* Foundation, Inc.,                                                   *)
(* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           *)
(***********************************************************************)

let rec sources_filter mdle = function
  | hd :: tl ->
      let source = Files.chop_suffix hd in
	if mdle = source then
	  sources_filter mdle tl
	else
	  source :: sources_filter mdle tl
  | [] -> []

let rec clean_dependencies = function
  | (target, sources) :: t ->
      if Files.is_cmo target then
	let mdle = Files.chop_suffix target in
	  (mdle, sources_filter mdle sources) :: clean_dependencies t
      else
	clean_dependencies t
  | [] -> []

let rec add_independent_dependencies deps = function 
  | h :: t -> 
      let h =	Files.chop_suffix h in
	if List.mem_assoc h deps then
	  add_independent_dependencies deps t
	else
	  add_independent_dependencies ((h, []) :: deps) t
  | [] -> deps
      
let get_dependencies param =
  let raw_deps = Dep_parse.parse_ocamldep (Params.to_stream param) in
  let cleaned_deps = clean_dependencies raw_deps in
    add_independent_dependencies cleaned_deps (Params.to_files param)
