(***********************************************************************)
(*                           ocamldsort                                *)
(*                                                                     *)
(*                 Copyright (C) 2002  Dimitri Ara                     *)
(*                                                                     *)
(* This program is free software; you can redistribute it and/or       *)
(* modify it under the terms of the GNU General Public License         *)
(* as published by the Free Software Foundation; either version 2      *)
(* of the License, or (at your option) any later version.              *)
(*                                                                     *)
(* This program is distributed in the hope that it will be useful,     *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of      *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *)
(* GNU General Public License for more details.                        *)
(*                                                                     *)
(* You should have received a copy of the GNU General Public License   *)
(* along with this program; if not, write to the Free Software         *)
(* Foundation, Inc.,                                                   *)
(* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           *)
(***********************************************************************)

exception Unknown_extension of string

let is_cmo file =
  Filename.check_suffix file ".cmo"

let suffix_list = 
  [".cmo"; ".cmi"; ".ml"; ".mli";
   ".mll"; ".mly" ]
    
let chop_suffix file =
  let rec chop_suffix_aux = function
    | hd :: tl ->
	if Filename.check_suffix file hd then
	  Filename.chop_suffix file hd
	else
	  chop_suffix_aux tl
    | [] -> raise (Unknown_extension file) in
  chop_suffix_aux suffix_list

let to_ml file = 
  file ^ ".ml"
