{-# LANGUAGE MultiParamTypeClasses #-}

module Xi2 where

import qualified Data.List as List

import qualified Delta as D
import qualified GlobParStruct as GPS

type Mapping = [Int]

data Object = Object Int Int
              deriving (Eq, Ord, Show, Read)

data RawMorphism = RawMorphism Mapping Mapping
                   deriving (Eq, Ord, Show, Read)

data Morphism = Morphism {
                  source :: Object,
                  target :: Object,
                  rawMorphism :: RawMorphism
                } deriving (Eq, Ord, Show, Read)

compRawMorphism :: RawMorphism -> RawMorphism -> RawMorphism
compRawMorphism (RawMorphism f' g') (RawMorphism f g@[_]) =
  RawMorphism (replicate (length f) 0) (D.compMapping g' g)
compRawMorphism (RawMorphism f' g') (RawMorphism f g) =
  RawMorphism (D.compMapping f' f) (D.compMapping g' g)

compMorphism :: Morphism -> Morphism -> Morphism
compMorphism (Morphism _ t g) (Morphism s _ f) =
  Morphism s t (compRawMorphism g f)

dim :: Object -> Int
dim (Object p 0) = 0
dim (Object p q) = p + q

isDim0 (Object _ 0) = True
isDim0 _            = False

monos :: Object -> Object -> [Morphism]
monos s@(Object p' q') t@(Object p q) 
  | q' /= 0 && q /= 0 =
    [ Morphism s t $ RawMorphism f g | f <- D.inj p' p, g <- D.inj q' q ]
  | q' == 0 =
    [ Morphism s t $ RawMorphism (replicate (p' + 1) 0) g | g <- D.inj q' q ]

objsD :: Int -> [Object]
objsD 0 = [Object 0 0]
objsD d = map (\i -> Object (d-i) i) [1..d]

objsMaxD :: Int -> [Object]
objsMaxD d = concatMap objsD [0..d]

subObjs :: Object -> [Morphism]
subObjs o = concatMap (flip monos o) (objsMaxD (dim o))

subObjsCodim1 :: Object -> [Morphism]
subObjsCodim1 o = concatMap (flip monos o) (objsD (dim o - 1))

st :: Object -> ([Morphism], [Morphism])
st o = List.partition odd (subObjsCodim1 o)
  where odd (Morphism (Object p' q') (Object p q) (RawMorphism f g))
          | p' == p = (-1)^p' * sign q g == -1
          | q' == q = sign p f == -1
        sign p f = let e = head $ [0..p] List.\\ f
                   in (-1)^e

instance GPS.DimCategory Object Morphism where
  source = source
  compose = compMorphism
  dim = dim
  isDim0 = isDim0
  subObjsCodim1 = subObjsCodim1

type GlobParStruct = GPS.GlobParStruct Object Morphism

globParStruct :: Int -> GlobParStruct
globParStruct d = List.foldl' add GPS.empty (objsMaxD d)
  where add acc o = GPS.insert o (st o) acc
