module Theta.Objects where

import qualified Data.MemoCombinators as Memo
import qualified Theta as T
import ExtList

partitions :: Int -> Int -> [[Int]]
partitions = Memo.integral partitions'
  where partitions' 0 n = [replicate n 0]
        partitions' _ 0 = []
        partitions' d n = concatMap (complete d n) [0..d]
          where complete d n n0 = map (n0:) (partitions (d - n0) (n - 1))

objsDMaxH :: Int -> Int -> [T.Object]
objsDMaxH = Memo.memo2 Memo.integral Memo.integral objsDMaxH'
  where objsDMaxH' 0 _ = [T.Zero]
        objsDMaxH' _ 0 = []
        objsDMaxH' d h = concatMap (complete d h) [1..d]
          where complete d h n = 
                  do
                    p <- partitions (d - n) n
                    decP <- cartProd $ map (flip objsDMaxH (h - 1)) p
                    return $ T.Wreath n decP

objsMaxDMaxH :: Int -> Int -> [T.Object]
objsMaxDMaxH d h = concatMap (flip objsDMaxH h) [0..d]

objsD :: Int -> [T.Object]
objsD d = objsDMaxH d d

objsMaxD :: Int -> [T.Object]
objsMaxD d = objsMaxDMaxH d d

objsSmaller :: T.Object -> [T.Object]
objsSmaller o = objsMaxDMaxH (T.dim o) (T.height o)

objsSmallerCodim1 :: T.Object -> [T.Object]
objsSmallerCodim1 o = objsDMaxH (T.dim o - 1) (T.height o)
