{-# LANGUAGE MultiParamTypeClasses #-}

module Theta.Monos where

import Data.List as List
import ExtList
import qualified Theta as T
import qualified Theta.Objects as TO
import qualified Delta as D

multiRawMonos :: T.Object -> [T.Object] -> [[T.RawMorphism]]
multiRawMonos s ts
  | s == T.Zero =
      map (map (T.MZero . head)) mis
  | otherwise =
      concatMap (complete (T.cotrunc1 s) (map T.cotrunc1 ts)) mis
  where mis = D.multiInj (T.trunc1 s) (map T.trunc1 ts)
        complete s1 ts1 mi =
          let splObjs = map concat $ transpose $ zipWith T.splitWreath mi ts1
              monos1Unord = cartProd $ zipWith multiRawMonos s1 splObjs
              sizes = transpose $ map diff mi
              monos1 = map (transpose . zipWith splitSize sizes)
                           monos1Unord
          in  map (zipWith T.MWreath mi) monos1

rawMonos :: T.Object -> T.Object -> [T.RawMorphism]
rawMonos s t = map head (multiRawMonos s [t])

existsMonos :: T.Object -> T.Object -> Bool
existsMonos s t = not . null $ rawMonos s t

monos :: T.Object -> T.Object -> [T.Morphism]
monos s t = map (T.Morphism s t) (rawMonos s t)

srcSubObjs :: T.Object -> [T.Object]
srcSubObjs o = filter (flip existsMonos o) (TO.objsSmaller o)

srcSubObjsCodim1 :: T.Object -> [T.Object]
srcSubObjsCodim1 o = filter (flip existsMonos o) (TO.objsSmallerCodim1 o)

subObjs :: T.Object -> [T.Morphism]
subObjs o = concatMap (flip monos o) (TO.objsSmaller o)

subObjsCodim1 :: T.Object -> [T.Morphism]
subObjsCodim1 o = concatMap (flip monos o) (TO.objsSmallerCodim1 o)
