{-# LANGUAGE MultiParamTypeClasses #-}

module Theta.GlobParStruct where

import qualified Data.Map as Map
import qualified Data.List as List
import qualified Data.Set as Set
import Data.Maybe

import ExtList
import qualified Theta as T
import qualified Theta.Monos as TH
import qualified Theta.Objects as TO
import qualified GlobParStruct as GPS

instance GPS.DimCategory T.Object T.Morphism where
  source = T.source
  compose = T.compMorphism
  dim = T.dim
  isDim0 = T.isDim0
  subObjsCodim1 = TH.subObjsCodim1

type GlobParStruct = GPS.GlobParStruct T.Object T.Morphism
type SourcesTargets = GPS.SourcesTargets T.Object T.Morphism
type CheckGPSFunST = GPS.CheckGPSFunST T.Object T.Morphism

--
-- initial GPS
--

suspendST :: SourcesTargets -> SourcesTargets
suspendST (s, t) = (map T.suspendMorph s, map T.suspendMorph t)
 
stDisk :: Int -> SourcesTargets
stDisk 0 = ([], [])
stDisk d = ([T.sourceDisk d], [T.targetDisk d])

stDelta :: Int -> SourcesTargets
stDelta 0 = stDisk 0
stDelta d = oddEven $ reverse $ TH.subObjsCodim1 (T.delta d)

stDeltaSusp :: Int -> Int -> SourcesTargets
stDeltaSusp n 0 = stDelta n
stDeltaSusp n s = suspendST (stDeltaSusp n (s - 1))

addDisks :: Int -> Int -> GlobParStruct -> GlobParStruct
addDisks d h gps = List.foldl' add gps [0..min d h]
  where add acc d' = GPS.insert (T.disk d') (stDisk d') acc

addDeltas :: Int -> Int -> GlobParStruct -> GlobParStruct
addDeltas d 0 gps = addDisks 0 0 gps
addDeltas d h gps = List.foldl' add gps [0..d]
  where add acc d' = GPS.insert (T.delta d') (stDelta d') acc

addSuspDeltas :: Int -> Int -> GlobParStruct -> GlobParStruct
addSuspDeltas d h gps = List.foldl' add gps idxs
  where add acc (n, s) = GPS.insert (T.suspendN s (T.delta n))
                                    (stDeltaSusp n s) acc
        idxs = [(n, s) | n <- [0..d], s <- [0..min (d - n) h]]

initEmpty :: Int -> Int -> GlobParStruct
initEmpty d h = GPS.empty

initDisks :: Int -> Int -> GlobParStruct
initDisks d h = addDisks d h GPS.empty

initDisksDeltas :: Int -> Int -> GlobParStruct
initDisksDeltas d h =
  (addDeltas d h) . (addDisks d h) $ GPS.empty

initSuspDisksDeltas :: Int -> Int -> GlobParStruct
initSuspDisksDeltas d h =
  (addSuspDeltas d h) . (addDisks d h) $ GPS.empty

---
--- generate GPS
---

genericGenerate' :: Int -> Int -> (Int -> Int -> GlobParStruct) ->
                   CheckGPSFunST -> [GlobParStruct]
genericGenerate' d h g f =
  GPS.generate (TO.objsMaxDMaxH d h) (TO.objsDMaxH (d + 1) h) [g d h] f

genericGenerate :: Int -> Int -> (Int -> Int -> GlobParStruct) ->
                   CheckGPSFunST -> [GlobParStruct]
genericGenerate d h g f =
  GPS.generate (TO.objsMaxDMaxH d h) [] [g d h] f

generate' :: Int -> Int -> [GlobParStruct]
generate' d h = genericGenerate' d h initDisks GPS.checkAllST

generate :: Int -> Int -> [GlobParStruct]
generate d h = genericGenerate d h initDisks GPS.checkAllST
