-- This program shows that if remove only one tree of dimension 5 and its
-- symmetrical it is then possible to define Theta_2-orientals for trees of
-- dimension at most 4

import System.Environment

import qualified GlobParStruct as GPS
import Theta
import qualified Theta.Objects as TO
import qualified Theta.GlobParStruct as TGPS

mainPure =
  let os = TO.objsMaxDMaxH 4 2
      os' = os ++
                [
                 wreath3 (delta 0) (delta 1) (delta 1)
                 ,
                 wreath3 (delta 1) (delta 1) (delta 0)
                 ,
                 wreath3 (delta 0) (delta 2) (delta 0)
                 ,
                 wreath3 (delta 1) (delta 0) (delta 1)
                  ,
                 wreath4 (delta 0) (delta 1) (delta 0) (delta 0)
                 ,
                 wreath4 (delta 0) (delta 0) (delta 1) (delta 0)
                ]
  in GPS.generate os' [] [TGPS.initDisks 4 2] GPS.checkAllST

main = do
  putStrLn $ show $ length $ mainPure
