-- This program computes for each tree T of dimension d + 1 of Theta_2 the
-- the (normalized) number of global parity structures on trees of dimension
-- at most d of Theta_2 "satisfying the cocycle condition" associated to T.

import System.Environment

import ExtList
import qualified Theta.GlobParStruct as TGPS   
import qualified Theta.Objects as TO
import qualified GlobParStruct as GPS

mainPure d =
  for (TO.objsDMaxH (d + 1) 2) (\o -> 
    let ngps = GPS.generate [o] [] gps GPS.checkAllST
    in (o, toRational (length ngps) / toRational(length gps)))
  where gps = TGPS.generate d 2

main = do
  args <- getArgs
  putStrLn $ show $ mainPure $ read (args !! 0)
