-- This program computes the number of global parity structure on trees of
-- dimension at most d of Theta_2 (with a fixed orientation of disks)
--
-- For d = 4, we get 0. This shows that it is not possible to define
-- Theta_2-orientals for trees of dimension at most 4

import System.Environment

import qualified GlobParStruct as GPS
import qualified Theta.GlobParStruct as TGPS

mainPure d = TGPS.generate' d 2
  
main = do
  args <- getArgs
  putStrLn $ show $ length $ mainPure $ read (args !! 0)
