module FreeAbGrp where

import qualified Data.Map as Map

newtype FreeAbGrp a = FreeAbGrp { freeAbGrp :: Map.Map a Int }
                      deriving (Eq, Show)

instance (Ord a) => Num (FreeAbGrp a) where
  (+) = lift2FAB (+)
  (-) = lift2FAB (-)
  negate = liftFAB negate
  (*) = error ""
  abs _ = error ""
  signum _ = error ""
  fromInteger _ = error "" 

-- Haskell sucks! There's no way to define monads on ordered sets
-- instance Monad (FreeAbGrp) where
--    return = returnFAB
--    (>>=) = bindFAB

zero :: FreeAbGrp a
zero = FreeAbGrp (Map.empty)

foldrBasis :: (a -> Int -> b -> b) -> b -> FreeAbGrp a -> b
foldrBasis f z = Map.foldrWithKey f z . freeAbGrp

modComp :: (Ord a) => a -> Int -> FreeAbGrp a -> FreeAbGrp a
modComp k 0 = FreeAbGrp . Map.delete k . freeAbGrp
modComp k n = FreeAbGrp . Map.insert k n . freeAbGrp

getComp :: (Ord a) => a -> FreeAbGrp a -> Maybe Int
getComp k = Map.lookup k . freeAbGrp

getComp0 :: (Ord a) => a -> FreeAbGrp a -> Int
getComp0 k x = case getComp k x of
                 Nothing -> 0
                 Just n -> n

addComp :: (Ord a) => a -> Int -> FreeAbGrp a -> FreeAbGrp a
addComp k n x = modComp k (n + (getComp0 k x)) x

coeffs :: FreeAbGrp a -> [Int]
coeffs = Map.elems . freeAbGrp

liftFAB :: (Ord a) => (Int -> Int) -> FreeAbGrp a -> FreeAbGrp a
liftFAB f = foldrBasis (\k n -> modComp k (f n)) zero

lift2FAB :: (Ord a) => (Int -> Int -> Int) ->
                          FreeAbGrp a -> FreeAbGrp a -> FreeAbGrp a
lift2FAB f x = foldrBasis (\k n -> modComp k (f (getComp0 k x) n)) x

dirac :: (Ord a) => a -> FreeAbGrp a
dirac k = modComp k 1 zero

bindFAB :: (Ord a, Ord b) => FreeAbGrp a -> (a -> FreeAbGrp b) -> FreeAbGrp b
bindFAB x f =
  foldrBasis (\k n acc -> 
    foldrBasis (\k' n' acc' ->
      addComp k' (n*n') acc')
      acc (f k))
    zero x

returnFAB :: (Ord a) => a -> FreeAbGrp a
returnFAB = dirac

(?>>=) :: (Ord a, Ord b) => FreeAbGrp a -> (a -> FreeAbGrp b) -> FreeAbGrp b
(?>>=) = bindFAB

fromList :: (Ord a) => [a] -> FreeAbGrp a
fromList = foldr (flip addComp 1) zero

posNegPart :: (Ord a) => FreeAbGrp a -> (FreeAbGrp a, FreeAbGrp a)
posNegPart = foldrBasis (\k n (accp, accn) ->
               if n > 0 then
                 (modComp k n accp, accn)
               else 
                 (accp, modComp k (-n) accn))
               (zero, zero)

posPart :: (Ord a) => FreeAbGrp a -> FreeAbGrp a
posPart = fst . posNegPart

negPart :: (Ord a) => FreeAbGrp a -> FreeAbGrp a
negPart = snd . posNegPart

support :: FreeAbGrp a -> [a]
support = foldrBasis (\k n acc ->
            if n /= 0 then
              k : acc
            else
             acc) []
