{-# LANGUAGE BangPatterns #-}

module ExtList where

import qualified Data.List as List

-- import Data.UArray

-- cartesian product

cartProd1 :: [a] -> [[a]] -> [[a]]
cartProd1 _  []     = []
cartProd1 xs (y:ys) = map (:y) xs ++ cartProd1 xs ys

cartProd :: [[a]] -> [[a]]
cartProd []     = [[]]
cartProd (x:xs) = cartProd1 x (cartProd xs) 

cartProdInt :: [Int] -> [[Int]]
cartProdInt = cartProd . map (\x -> [0..x])

--

{-
splitSize :: [Int] -> [a] -> [[a]]
splitSize [] xs = []
splitSize (n:ns) xs = f : (splitSize ns s)
  where (f, s) = splitAt n xs
-}

splitSize :: [Int] -> [a] -> [[a]]
splitSize [] xs = []
splitSize (n:ns) xs = f `seq` next `seq` f : next
  where (f, s) = splitAt n xs
        next = splitSize ns s

{-
diff :: (Num a) => [a] -> [a]
diff (x:xs) = aux x xs
  where aux i []     = []
        aux i (x:xs) = (x - i) : (aux x xs)
-}

diff :: (Num a) => [a] -> [a]
diff (x:xs) = aux x xs
  where aux i []     = []
        aux i (x:xs) = xi `seq` next `seq` xi : next
          where xi = x - i
                next = aux x xs

altSum :: (Num a) => [a] -> a
altSum []     = 0
altsum (x:xs) = x - altSum xs 

{-
takeIdxs :: [Int] -> [a] -> [a]
takeIdxs ns xs = map (ar !) ns
  where ar = listArray (0, l - 1) xs
        l = length xs
-}

takeIdxs :: [Int] -> [a] -> [a]
takeIdxs ns xs = map (xs !!) ns

biPartitions :: [a] -> [([a], [a])]
biPartitions []     = [([], [])]
biPartitions (x:xs) = complete (biPartitions xs) x
  where complete ys z =
          do (a, b) <- ys
             [(z:a, b), (a, z:b)]

-- use ++ (to fix?)
distPairs :: [a] -> [(a, a)]
distPairs []     = []
distPairs (x:xs) = (complete x xs) ++ distPairs xs
  where complete x []     = []
        complete x (y:ys) = (x, y) : complete x ys

disjoint :: (Eq a) => [a] -> [a] -> Bool
disjoint xs ys = null $ xs `List.intersect` ys

sortNub :: (Eq a, Ord a) => [a] -> [a]
sortNub xs = nub' (List.sort xs)
  where nub' [] = []
        nub' [x] = [x]
        nub' (x:xs@(x':_))
          | x == x' = nub' xs
          | otherwise = x : nub' xs

eqAsSet :: (Eq a, Ord a) => [a] -> [a] -> Bool
eqAsSet xs ys = sortNub xs == sortNub ys

-- 

for :: [a] -> (a -> b) -> [b]
for = flip map

forZip :: [a] -> [b] -> (a -> b -> c) -> [c]
forZip xs ys f = zipWith f xs ys

liftPairBin :: (a -> b -> c) -> ((a, a) -> (b, b) -> (c, c)) 
liftPairBin f (x, y) (x' ,y') = (f x x', f y y')

(?:) :: (a, a) -> ([a], [a]) -> ([a], [a])
(?:) = liftPairBin (:)

(?++) :: ([a], [a]) -> ([a], [a]) -> ([a], [a])
(?++) = liftPairBin (++)

concatPair :: [([a], [a])] -> ([a], [a])
concatPair = foldr (?++) ([], [])


evenOdd :: [a] -> ([a], [a])
evenOdd [] = ([], [])
evenOdd [x] = ([x], [])
evenOdd (x:x':xs) = (x, x') ?: evenOdd xs

swap :: (a, b) -> (b, a)
swap (x, y) = (y, x)

oddEven :: [a] -> ([a], [a])
oddEven = swap . evenOdd

length1 :: [a] -> Bool
length1 (x:[]) = True
length1 _      = False
