module Delta where

import Data.List as List
import ExtList

type Simplex = Int
type Mapping = [Int]

multiInjInv :: Simplex -> [Simplex] -> [[[Int]]]
multiInjInv 0 ts = map return (cartProdInt ts)
multiInjInv s ts = concatMap complete (multiInjInv (s - 1) ts)
  where complete l = map (:l) (List.delete h (cartProdInt h))
                       where h = head l

multiInj :: Simplex -> [Simplex] -> [[Mapping]]
multiInj s ts = map transpose (multiInjInv s ts)

inj :: Simplex -> Simplex -> [Mapping]
inj s t = concat $ multiInj s [t]

evalMapping :: Mapping -> Int -> Int
evalMapping f x = f !! x

compMapping :: Mapping -> Mapping -> Mapping
compMapping g f = takeIdxs f g
