var WEATHER_URL = 'http://api.openweathermap.org/data/2.5/weather?';

function getWeatherInParis() {
  var script = document.createElement('script');
  script.setAttribute('src', WEATHER_URL + 'q=Paris,fr&callback=callback');
  document.body.appendChild(script);
}

function callback(data) {
  var div = document.getElementById('response');
  var p = document.createElement('p');
  var text = document.createTextNode(
    'Current weather in ' + data.name + ': ' + 
      data.weather[0].description + ', ' + 
      Math.round(data.main.temp - 273.15) + '°C');
  p.appendChild(text);
  div.appendChild(p);
}

function getWeatherInCity(city, cbName) {
  var script = document.createElement('script');
  script.setAttribute('src', WEATHER_URL + 'q=' + city + '&callback=' + cbName);
  document.body.appendChild(script);
}

function getWeatherInParisAndLyon() {
  getWeatherInCity('Paris,fr', 'callback');
  getWeatherInCity('Lyon,fr', 'callback');
}
