% *************************************************************************
% tp-caml-2003
% Classe LaTeX2e pour TPs Caml
% Vincent Simonet
% *************************************************************************



% *************************************************************************
% En-tte de la classe

\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{tp-caml-2003}[2002/09/09 v1.0]

% On se base sur la classe article en 10 points
\LoadClass[10pt,twoside]{article}

% On utilise multicol pour le corps de l'nonc en deux colonnes
\RequirePackage{multicol}

% Les sujets sont cods en latin1 et crits en franais
\RequirePackage[latin1]{inputenc}
\RequirePackage[francais]{babel}

% Packages mathmatiques usuels
\RequirePackage{amsmath,amssymb}
\RequirePackage{stmaryrd}

% Le code source Caml est mis en forme par listings
\RequirePackage{listings}

% Les corrigs sont faits avec exercise
\RequirePackage{exercise}

% On distingue une version publique de celle distribue aux lves
\RequirePackage{vs-version}

\RequirePackage{keyval}
\RequirePackage{ifthen}
\RequirePackage{url}

\newif\if@vs@answer
\@vs@answertrue
\DeclareOption{noanswer}{\@vs@answerfalse}

\ProcessOptions



% *************************************************************************
% Configuration des packages

% -------------------------------------------------------------------------
% listings
\lstloadlanguages{Caml}
\lstset{%
  language=[light]Caml,%
  basicstyle=\normalfont\sffamily,
  stringstyle=\itshape,
  commentstyle=\itshape,
  framesep=5pt}

% L'environnement caml est utilis pour afficher les prototypes
\lstnewenvironment{caml}[1][0]
{\lstset{%
    boxpos=c,
    frame=lb,
    basewidth={0.55em,0.45em},
    xleftmargin=0.5cm,
    xrightmargin=0.5cm,
    columns=fullflexible,
%    flexiblecolumns=true,
    gobble=#1
  }%
  \medskip%
  \scriptsize%
}
{\normalfont\bigskip}

\lstnewenvironment{prototype}[1][4]
{\lstset{%
    columns=fullflexible,
%    flexiblecolumns=true,
    gobble=#1
}\scriptsize}
{\normalfont}



% -------------------------------------------------------------------------
% multicol

\setlength{\columnseprule}{0pt}
\setlength{\columnsep}{1cm}



% -------------------------------------------------------------------------
% vs-version

\declareversion{private}
\declareversion{diffused}
\defaultversion{private}



% -------------------------------------------------------------------------
% answers
\renewcommand{\AnswerSection}[1]{}



% *************************************************************************
% Parametres

\define@key{vs@tp}{title}[]{\gdef\vs@tptitle{#1}}
\define@key{vs@tp}{number}[]{\gdef\vs@tpnumber{#1}}
\define@key{vs@tp}{date}[]{\gdef\vs@tpdate{#1}}
\define@key{vs@tp}{class}[]{\gdef\vs@tpclass{#1}}

\newcommand{\tp}[1]{\setkeys{vs@tp}{#1}}



% *************************************************************************
% Format de la page

\paperheight=29.7cm
\paperwidth=21cm

\setlength{\textwidth}{18cm}
\setlength{\hoffset}{-1in}
\setlength{\marginparsep}{0cm}
\setlength{\marginparwidth}{0cm}
\setlength{\marginparpush}{0cm}
\setlength{\evensidemargin}{1.5cm}
\setlength{\oddsidemargin}{1.5cm}
\setlength{\topmargin}{1cm}
\setlength{\headheight}{0cm}
\setlength{\headsep}{0cm}
\setlength{\voffset}{-1in}
\setlength{\textheight}{26.7cm}
\setlength{\footskip}{1cm}
\setlength{\parindent}{0cm}



% *************************************************************************
% Mise en forme du texte

% -------------------------------------------------------------------------
% Titre
\newcommand{\vs@Header}[3]{%
  \begin{minipage}[t][3cm]{10cm}
    \sffamily
    \begin{tabular}{@{}l@{\hspace{0.2cm}}l@{\hspace{0.2cm}}}
      $\blacktriangleright$ & \textbf{#1} \\
                            & #2 \\
                            & #3
    \end{tabular}%
  \end{minipage}%
}

\newcommand{\vs@header}{%
  \ifdiffused{%
    \vs@Header{{\vs@tpclass} -- Option Informatique}
    {Anne 2002--2003, {\vs@tpnumber} TP Caml}
    {Vincent Simonet (\url{http://cristal.inria.fr/~simonet/})}%
  }%
  \ifprivate{%
    \vs@Header{{\vs@tpclass} -- Option Informatique}
    {{\vs@tpnumber} TP Caml}
    {\vs@tpdate}
  }%
}

\newcommand{\vs@title}[2]{%
  \thispagestyle{empty}%
  \global\@topnum\z@   % Prevents figures from going at top of page.
  \begin{center}%
    \huge\textbf{\textsf{#1}}\par%
    \ifthenelse{\equal{#2}{}}{}{\vspace{0.4em}\large\textbf{\textsf{#2}}\par}
  \end{center}
  \vspace{2cm}
}

\def\ps@vs@copyright{
  \def\@oddfoot{\tiny\vbox{\hbox{\copyright\ Vincent Simonet 2002}
    \hbox{Ce document est distribu selon les termes de la
    GNU Free Documentation License.}}}}



% -------------------------------------------------------------------------
% Abstract

\newcommand{\tpsource}[1]{%
  \begin{center}
    \normalfont\bfseries #1
  \end{center}
}

\newlength{\avsabstractwidth}
\renewenvironment{abstract}[1][\abstractname]
{%
  \setlength{\avsabstractwidth}{-4cm}%
  \addtolength{\avsabstractwidth}{\linewidth}%
  \begin{center}%
    \begin{minipage}{\avsabstractwidth}%
      \slshape%
}
{%
    \end{minipage}%
  \end{center}%
  \vspace{2cm}%
}



% -------------------------------------------------------------------------
% Corps du document

\newenvironment{corpus}
{%
  \begin{multicols}{2}%
  \fragileanswer{\string \begin{multicols*}{2}}%
  \fragileanswer{\string \raggedcolumns}%
}
{%
  \end{multicols}
  \fragileanswer{\string \end{multicols*}}%
}



% -------------------------------------------------------------------------
% Questions et rponses

\newcounter{vs@question}
\setcounter{vs@question}{0}

\newenvironment{question}{%
  \refstepcounter{vs@question}%
  \fragileanswer{\string \stepcounter{vs@question}}%
  \bigskip%
  \textsf{\mbox{\textbf{%
        $\blacktriangleright$ Question \arabic{vs@question}}\enspace}}%
  \itshape%
}
{\medskip}

\newanswer{solution}{}{}{}{}{}{%
  \par%
  \bigskip%
  \textsf{\mbox{\textbf{%
        $\blacktriangleright$ Question \arabic{vs@question}}\enspace}}%
}
{\medskip}
\newanswer{solution-caml}
{\fragileanswer{\string \begin{caml}}}
{\fragileanswer{\string \end{caml}}}
{}{}{}{%
  \par%
  \bigskip%
  \textsf{\mbox{\textbf{%
        $\blacktriangleright$ Question \arabic{vs@question}}\enspace}}%
}
{\medskip}



% -------------------------------------------------------------------------
% Sections

\renewcommand{\@seccntformat}[1]
{\textbf{\csname the#1\endcsname}\hspace{0.5em}}

\renewcommand\section
{\@startsection{section}{1}{\z@}%
               {-3.5ex \@plus -1ex \@minus -.2ex}%
               {2.3ex \@plus.2ex}%
               {\normalfont\Large\bfseries\sffamily\raggedright}}

\renewcommand\subsection
{\@startsection{subsection}{2}{\z@}%
               {-3.25ex\@plus -1ex \@minus -.2ex}%
               {1.5ex \@plus .2ex}%
               {\normalfont\large\sffamily}}

\renewcommand\subsubsection
{\@startsection{subsubsection}{3}{\z@}%
               {-3.25ex\@plus -1ex \@minus -.2ex}%
               {1.5ex \@plus .2ex}%
               {\normalfont\normalsize\sffamily}}

\renewcommand\paragraph
{\@startsection{paragraph}{4}{\z@}%
               {3.25ex \@plus1ex \@minus.2ex}%
               {-1em}%
               {\normalfont\normalsize\bfseries\sffamily}}

\renewcommand\subparagraph
{\@startsection{subparagraph}{5}{\parindent}%
               {3.25ex \@plus1ex \@minus .2ex}%
               {-1em}%
               {\normalfont\normalsize\sffamily}}



% *************************************************************************
% Misc

\newcommand{\answerbreak}{\fragileanswer{\string \Answerbreak}}
\newcommand{\Answerbreak}{\par\columnbreak}



% *************************************************************************
% Hooks

\AtBeginDocument{%
  \vs@header%
  \vs@title{\vs@tptitle}{}
  \ifdiffused{\thispagestyle{vs@copyright}}
}

\AtEndDocument{%
\if@vs@answer
  \ifdiffused{\clearpage}\ifprivate{\cleardoublepage}%
  \setcounter{vs@question}{0}%
  \setcounter{page}{1}%
  \vs@header%
  \vs@title{\vs@tptitle}{Un corrig}%
  \inputanswers{}%
\fi
}
