% ********************************************************************
% * En-tte de la classe                                             *
% ********************************************************************

\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{tp-caml-2001}[2000/07/31 v1.1]

% Cette classe est base sur la classe "article" de la distribution
% standard de LaTeX.
\LoadClass[10pt]{article}



% AUTRES PACKAGES REQUIS
\RequirePackage[latin1]{inputenc}
\RequirePackage[francais]{babel}
\RequirePackage{avsstyle}
\RequirePackage{multicol}
\RequirePackage{listings}
\lstloadlanguages{Caml} 
\RequirePackage{exercise}
\RequirePackage{xspace}
\RequirePackage{amsmath,amssymb}
\RequirePackage{stmaryrd}
\RequirePackage{url}
\RequirePackage{vs-version}


\declareversion{private}
\declareversion{diffused}
\defaultversion{private}



% ********************************************************************
% * Quelques notations matematiques                                  *
% ********************************************************************

\newcommand{\parts}{\mathcal{P}}
\newcommand{\eqv}{\Leftrightarrow}
\newcommand{\impl}{\Rightarrow}


\def\@tpnumber{}
\def\tpnumber#1{\gdef\@tpnumber{#1}}
\def\@tpdate{}
\def\tpdate#1{\gdef\@tpdate{#1}}




% ********************************************************************
% * Prototypes Caml (mode 2001)                                     *
% ********************************************************************

\newcommand{\tint}{\mathit{int}}
\newcommand{\tstring}{\mathit{string}}
\newcommand{\tunit}{\mathit{unit}}
\newcommand{\tbool}{\mathit{bool}}
\newcommand{\texpr}{\mathit{expr}}
\newcommand{\tfun}[2]{{#1} \mathbin{\rightarrow} {#2}}
\newcommand{\tpair}[2]{{#1} \mathbin{\times} {#2}}
\newcommand{\tvect}[1]{{#1}\ \mathit{vect}}
\newcommand{\tlist}[1]{{#1}\ \mathit{list}}
\newcommand{\tref}[1]{{#1}\ \mathit{ref}}
\newcommand{\toption}[1]{{#1}\ \mathit{option}}
\newcommand{\ttree}[1]{{#1}\ \mathit{tree}}
\newcommand{\tprod}[2]{{#1} \mathbin{\times} {#2}}

\newcommand{\prototype}[2]
{\nopagebreak\par\smallskip \normalfont\textsf{value #1} : $#2$}



% ********************************************************************
% * Environnements pour la mise en forme de l'nonc                 *
% ********************************************************************

% SECTIONS

% \let\savedsection\section
% \def\section #1 {%
% \fragileanswer{\string \savedsection{#1}}%
% \savedsection{#1}%
% }

% QUESTION
% L'environnement question peut tre utilis pour mettre en valeur
% les questions auxquelles le lecteur doit rpondre. Ces questions
% sont numrotes.
\newcounter{avsenonceQuestion}
\setcounter{avsenonceQuestion}{0}
\newcounter{avsenonceSolution}
\setcounter{avsenonceSolution}{0}

\newenvironment{question}[1][]
{\refstepcounter{avsenonceQuestion}%
\fragileanswer{\string \stepcounter{avsenonceSolution}}%
\bigskip%
\textsf{\mbox{\textbf{$\blacktriangleright$ Question
    \arabic{avsenonceQuestion}\ifnotempty{#1}{ (#1)}} \enspace}}%
\itshape}
{\medskip}

\renewcommand{\AnswerSection}[1]{}
\newenvironment{solution}
{\par\bigskip%
\textsf{\mbox{\textbf{$\blacktriangleright$ Question
    \arabic{avsenonceSolution}} \enspace}}}
{\medskip}


% CODE CAML
\lstnewenvironment{listing-caml}
{\lstset{boxpos=c,stringstyle=\slshape,commentstyle=\slshape,stringspaces=false,frame=lb,frameround=fftf,spread=-2cm,basewidth={0.55em,0.45em}}%
\medskip\scriptsize}
{\normalfont\bigskip}


\newcommand{\Caml}{\textsl{Caml}\xspace}


% ********************************************************************
% * Format de la page                                                *
% ********************************************************************

   \paperheight=29.7cm
   \paperwidth=21cm

   \setlength\textwidth{18cm}
   \hoffset=-1in
   \setlength\marginparsep{0cm}
   \setlength\marginparwidth{0cm}
   \setlength\marginparpush{0cm}
   \setlength\evensidemargin{1.5cm}
   \setlength\oddsidemargin{1.5cm}
   \setlength\topmargin{1cm}
   \setlength\headheight{0cm}
   \setlength\headsep{0cm}
   \voffset=-1in
   \setlength\textheight{26.7cm}
   \footskip=1cm

   \setlength{\parindent}{0cm}



% ********************************************************************
% * At Begin Document                                                *
% ********************************************************************

\def\ps@copyright{
  \def\@oddfoot{\tiny\vbox{\hbox{\copyright\ Vincent Simonet 2001}
    \hbox{Ce document est distribu selon les termes de la
    GNU Free Documentation License.}}}}

\newcommand{\entete}[3]{%
  \begin{minipage}[t][3cm]{10cm}
    \sffamily
    \begin{tabular}{@{}l@{\hspace{0.2cm}}l@{\hspace{0.2cm}}}
      $\blacktriangleright$ & \textbf{#1} \\
                            & #2 \\
                            & #3 \\
                            %%\hline
    \end{tabular}
  \end{minipage}%
}


\spacebeforetitle{0cm}

\AtBeginDocument{%

  \pagestyle{plain}%
  \lstset{language=[light]Caml,basicstyle=\normalfont\sffamily}


  \ifdiffused{%
    \entete{MPSI -- Option Informatique}{Anne 2001, \@tpnumber\ TP
      Caml}{Vincent Simonet (\url{http://cristal.inria.fr/~simonet/})}%
  }
  \ifprivate{%
    \entete{MPSI -- Option Informatique}{\@tpnumber\ TP Caml}{\@tpdate}
  }

  \author{}
  \date{}\maketitle
  \setlength{\columnseprule}{0pt}
  \setlength{\columnsep}{1cm}
  \ifdiffused{\thispagestyle{copyright}}
}



% ********************************************************************
% * At End Document                                                  *
% ********************************************************************

\AtEndDocument{%

\newpage
\setcounter{section}{0}
\setcounter{page}{1}

\subtitle{Un corrig}
  \ifdiffused{%
     \entete{MPSI -- Option Informatique}{Anne 2001, \@tpnumber\ TP
       Caml}{Vincent Simonet
       (\url{http://cristal.inria.fr/~simonet/})}
   }
   \ifprivate{%
     \entete{MPSI -- Option Informatique}{\@tpnumber\ TP Caml}{\@tpdate}}

  \maketitle
  \begin{multicols*}{2}
%    \makeatletter
    \inputanswers{}
%    \makeatother
  \end{multicols*}
}
