(**************************************************************************)
(*                                                                        *)
(*                                  Dalton                                *)
(*                      an efficient implementation of                    *)
(*                 type inference with structural subtyping               *)
(*                                                                        *)
(*          Vincent Simonet, Projet Cristal, INRIA Rocquencourt           *)
(*                                                                        *)
(*  Copyright 2002 Institut National de Recherche en Informatique et en   *)
(*  Automatique.  All rights reserved.  This file is distributed under    *)
(*  the terms of the GNU Library General Public License, with the         *)
(*  special exception on linking described in file LICENSE.               *)
(*                                                                        *)
(*  Author contact: Vincent.Simonet@inria.fr                              *)
(*  Software page: http://cristal.inria.fr/~simonet/soft/dalton/          *)
(*                                                                        *)
(**************************************************************************)

(* $Id: dalton_debug.ml,v 1.1 2002/10/29 15:46:58 simonet Exp $ *)



let skip_terminal = ref false

let terminal = ref 10

let print_polarities = ref false

let no_ghost = ref false



(***************************************************************************)
(** {2 Statistics} *)

module Stat = struct

  type t = 
      { mutable node: int;
	mutable node_ext: int;
	mutable node_copy: int;
	mutable expanded: int;
	mutable unexpanded: int;
	mutable cycle: int;
	mutable fork: int;
	mutable minimization: int;
	mutable gc: int;
	mutable hash_consing: int
      }

  let create () =
    { node = 0;
      node_ext = 0;
      node_copy = 0;
      expanded = 0;
      unexpanded = 0;
      cycle = 0;
      fork = 0;
      minimization = 0;
      gc = 0;
      hash_consing = 0
    }

  let major = create ()
  let minor = create ()

  let iter f =
    f major; f minor

  let reset s = 
    s.node <- 0;
    s.node_ext <- 0;
    s.node_copy <- 0;
    s.expanded <- 0;
    s.unexpanded <- 0;
    s.cycle <- 0;
    s.fork <- 0;
    s.minimization <- 0;
    s.gc <- 0;
    s.hash_consing <- 0

  let output oc s =
    Printf.fprintf oc "  nodes: %6i (%6i ext, %6i copy)   expanded: %6i vs %6i\n"
      s.node s.node_ext s.node_copy s.expanded s.unexpanded;
    Printf.fprintf oc
      "  cycle: %6i   fork: %6i   gc: %6i   minimization: %6i   \
      hash-consing: %6i\n"
       s.cycle s.fork s.gc s.minimization s.hash_consing
      
  let reset_major () = iter reset
  let reset_minor () = reset minor
  let output_major oc = output oc major
  let output_minor oc = output oc minor
      

  let node () =
    iter (fun t -> t.node <- t.node + 1);
    true

  let node_ext () =
    iter (fun t -> t.node_ext <- t.node_ext + 1);
    true

  let node_copy () =
    iter (fun t -> t.node_copy <- t.node_copy + 1);
    true

  let expanded () =
    iter (fun t -> t.expanded <- t.expanded + 1);
    true

  let unexpanded () =
    iter (fun t -> t.unexpanded <- t.unexpanded + 1);
    true

  let cycle () =
    iter (fun t -> t.cycle <- t.cycle + 1);
    true

  let fork () =
    iter (fun t -> t.fork <- t.fork + 1);
    true

  let gc () =
    iter (fun t -> t.gc <- t.gc + 1);
    true

  let minimization () =
    iter (fun t -> t.minimization <- t.minimization + 1);
    true

  let hash_consing () =
    iter (fun t -> t.hash_consing <- t.hash_consing + 1);
    true

end
